package com.hero.objects.martialarts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.GenericObjectDialog;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class WeaponElement extends GenericObject {

    private static String xmlID = "WEAPON_ELEMENT";

    public WeaponElement(Element template) {
        super(template, WeaponElement.xmlID);
    }

    public WeaponElement(Element template, boolean dontUseID) {
        super(template);
    }

    @Override
    public boolean allowsOtherModifiers() {
        return false;
    }

    @Override
    public boolean allowsOtherAdders() {
        return false;
    }

    @Override
    protected void init(Element element) {
        display = "Weapon Element";
        alias = "Weapon Element";
        baseCost = 0;
        levelCost = 0;
        levelValue = 0;
        minimumCost = 1;
        minimumLevel = 0;
        super.init(element);
        alias = "Weapon Element";
    }

    @Override
    public String getColumn2Output() {
        String ret = getAlias();
        if (getInput() != null && getInput().trim().length() > 0) {
            ret += ":  " + getInput();
        }
        String adderString = getAdderString();
        if (adderString.trim().length() > 0) {
            ret += ":  ";
            ret += adderString;
        }
        String modifierString = getModifierString();
        if (modifierString.trim().length() > 0) {
            ret += " ";
            ret += getModifierString();
        }
        ret += getModifierString();
        if (getEndUsage() > 0
                && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(),
                        "ENDURANCERESERVE") != null
                && GenericObject.findObjectByID(getAllAssignedModifiers(), "ENDRESERVEOREND") == null
                && !HeroDesigner.getInstance().getPrefs().useWG()) {
            if (getUseENDReserve()) {
                ret += " (uses END Reserve)";
            } else {
                ret += " (uses Personal END)";
            }
        }
        return ret;
    }

    /**
     * Some custom work here to order elements according to the Writers'
     * Guidelines.
     */
    @Override
    public String getAdderString() {
        ArrayList<String> vec = new ArrayList<String>();
        for (Adder adder : assignedAdders) {
            adder.addAliasToVector(vec);
        }
        Collections.sort(vec, new Comparator() {
            public int compare(Object o1, Object o2) {
                String s1 = o1.toString();
                String s2 = o2.toString();
                if (s1.toUpperCase().trim().startsWith("COMMON")) {
                    if (s2.toUpperCase().trim().startsWith("COMMON")) {
                        return s1.compareTo(s2);
                    } else {
                        return -1;
                    }
                } else if (s2.toUpperCase().trim().startsWith("COMMON")) {
                    return 1;
                }
                return s1.compareTo(s2);
            }

            @Override
            public boolean equals(Object o) {
                return false;
            }
        });
        StringBuffer ret = new StringBuffer();
        for (String s : vec) {
            if (s.trim().length() > 0) {
                if (ret.length() > 0) {
                    ret.append(", ");
                }
                ret.append(s);
            }
        }

        return ret.toString();
    }

    @Override
    public Element getSaveXML() {
        Element root = getGeneralSaveXML();
        root.setName("WEAPON_ELEMENT");
        return root;
    }

    @Override
    public void restoreFromSave(Element root) {
        super.restoreFromSave(root);
    }

    @Override
    public GenericDialog getDialog(boolean isNew, boolean isPower) {
        GenericDialog d = new GenericObjectDialog(this, isNew, isPower);
        d.setNameVisible(false);
        return d;
    }
}